﻿//////////////////////////////////////////////
// ResourceManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkMemory
{
	class Buffer ;
}

/// Includes ---------------------------------

// nkResources
#include "Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkResources
{
	class DLL_RESOURCES_EXPORT ResourceManager final : public nkCommon::SingletonClass<ResourceManager>
	{
		public :

			// Working path
			void setWorkingPath (nkMemory::StringView path) ;
			void setWorkingPathAbsolute (nkMemory::StringView path) ;
			nkMemory::StringView getWorkingPath () const ;
			nkMemory::StringView getWorkingPathAbsolute () const ;

			// Launching path
			nkMemory::StringView getLaunchedPath () const ;
			void setLaunchedPath (nkMemory::StringView path) ;

			// Translations
			nkMemory::String getRelativeFromAbsolute (nkMemory::StringView absolutePath) const ;
			nkMemory::String getAbsoluteFromRelative (nkMemory::StringView relativePath) const ;
			nkMemory::String getRelativeFromWorkingDir (nkMemory::StringView workingPath) const ;
			nkMemory::String getAbsoluteFromWorkingDir (nkMemory::StringView workingPath) const ;
			nkMemory::String getFromWorkingDirFromRelative (nkMemory::StringView relativePath) const ;
			nkMemory::String getFromWorkingDirFromAbsolute (nkMemory::StringView absolutePath) const ;

			// Folder checks
			bool checkFileExists (nkMemory::StringView filePathAbs) const ;
			void checkFolderExists (nkMemory::StringView path) ;

			// Resource IO
			nkMemory::Buffer loadFileIntoMemory (nkMemory::StringView filePathAbs, bool silent = false) ;
			bool saveFileToDisk (nkMemory::StringView outPathAbs, nkMemory::BufferView<> data, bool silent = false) ;

		private :

			// Functions
			// Constructeur, destructeur
			ResourceManager() noexcept ;
			virtual ~ResourceManager () ;

		private :

			// Attributes
			// Paths
			nkMemory::String _workingPath ;
			nkMemory::String _workingPathAbsolute ;
			nkMemory::String _launchedPath ;

		private :

			friend class nkCommon::SingletonClass<ResourceManager> ;
	} ;
}